/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.result;

import filenet.vw.api.VWWorkObject;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.result.VWAdminWorkObjectTableData;
import filenet.vw.toolkit.admin.result.resources.VWResource;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.table.VWTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;

public final class VWAdminManageTrackerErrorDialog
extends VWModalDialog {
    private Container container = this.getContentPane();
    private JScrollPane scrollPane;
    private JButton m_yesButton = null;
    private JButton m_noButton = null;
    private JButton m_okButton = null;
    private JButton m_helpButton = null;
    private JTextArea m_infoTextArea = null;
    private JTable m_table = null;
    private DefaultTableModel m_tableModel = null;
    private Vector m_vErrors = new Vector();
    private Vector m_vWobs = new Vector();
    private JScrollPane m_scrollPane = null;
    private boolean m_bContinued = false;
    private boolean m_bYes = false;

    public VWAdminManageTrackerErrorDialog(Frame parent, Vector wobsVector, boolean bContinued) {
        super(parent);
        if (wobsVector.size() == 0) {
            JOptionPane.showMessageDialog(this.m_parent, VWResource.s_noErrorsRetrieved, VWResource.s_detailsTitle, 1, null);
            return;
        }
        this.m_vWobs = wobsVector;
        this.m_bContinued = bContinued;
        try {
            this.setResizable(true);
            Dimension dim = VWStringUtils.stringToDimension("665,275");
            if (dim == null) {
                dim = new Dimension(600, 250);
            }
            this.setSize(dim.width, dim.height);
            this.setVisible(false);
            this.setLocationRelativeTo(parent);
            this.setTitle(VWResource.s_manageTrackersTitle);
            this.buildTable();
            this.m_scrollPane = new JScrollPane(this.m_table);
            JPanel mainPanel = this.createMainPanel();
            JPanel buttonPanel = this.buildButtonPanel();
            this.container.setLayout(new BorderLayout());
            this.container.add((Component)mainPanel, "Center");
            this.container.add((Component)buttonPanel, "Last");
            this.container.add(Box.createVerticalStrut(20), "First");
            this.container.add(Box.createHorizontalStrut(20), "Before");
            this.container.add(Box.createHorizontalStrut(20), "After");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void windowClosing(WindowEvent event) {
        super.windowClosing(event);
        this.m_bYes = false;
    }

    private JPanel createMainPanel() {
        JPanel mainPanel = new JPanel();
        try {
            mainPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            mainPanel.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(2, 2, 2, 2);
            c.anchor = 23;
            c.gridx = 0;
            c.gridy = 0;
            c.gridheight = 1;
            c.gridwidth = 1;
            JTextArea label = new JTextArea();
            String text = VWResource.s_manageTrackersErrWithDelay + VWResource.s_referToHelpForInfo;
            label.setText(text);
            label.setLineWrap(true);
            label.setWrapStyleWord(true);
            label.setOpaque(false);
            label.setEditable(false);
            Icon icon = UIManager.getIcon("OptionPane.errorIcon");
            if (icon != null) {
                c.fill = 0;
                c.weightx = 0.0;
                c.weighty = 0.0;
                JLabel iconLabel = new JLabel(icon);
                mainPanel.add((Component)iconLabel, c);
                ++c.gridx;
            }
            c.fill = 1;
            c.weightx = 1.0;
            c.weighty = 0.0;
            mainPanel.add((Component)label, c);
            c.gridx = 0;
            ++c.gridy;
            c.anchor = 23;
            c.fill = 1;
            c.gridwidth = 0;
            c.gridheight = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.insets = new Insets(10, 2, 2, 2);
            mainPanel.add((Component)this.m_scrollPane, c);
            if (this.m_bContinued) {
                label = new JTextArea(VWResource.s_manageTrackersConfirmContinue);
                label.setLineWrap(true);
                label.setWrapStyleWord(true);
                label.setOpaque(false);
                label.setEditable(false);
                c.gridx = 0;
                ++c.gridy;
                c.anchor = 23;
                c.fill = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.insets = new Insets(10, 2, 2, 2);
                mainPanel.add((Component)label, c);
            }
            return mainPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel buildButtonPanel() {
        JPanel buttonPanel = null;
        GridBagConstraints gbCons = null;
        try {
            buttonPanel = new JPanel(new GridBagLayout());
            gbCons = new GridBagConstraints();
            gbCons.anchor = 10;
            gbCons.fill = 0;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(6, 6, 6, 6);
            if (this.m_bContinued) {
                this.m_yesButton = new JButton(VWResource.s_yes);
                this.m_yesButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        VWAdminManageTrackerErrorDialog.this.m_bYes = true;
                        VWAdminManageTrackerErrorDialog.this.setVisible(false);
                    }
                });
                buttonPanel.add((Component)this.m_yesButton, gbCons);
                this.m_noButton = new JButton(VWResource.s_no);
                this.m_noButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        VWAdminManageTrackerErrorDialog.this.m_bYes = false;
                        VWAdminManageTrackerErrorDialog.this.setVisible(false);
                    }
                });
                ++gbCons.gridx;
                buttonPanel.add((Component)this.m_noButton, gbCons);
            } else {
                this.m_okButton = new JButton(VWResource.s_OK);
                this.m_okButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        VWAdminManageTrackerErrorDialog.this.m_bYes = false;
                        VWAdminManageTrackerErrorDialog.this.setVisible(false);
                    }
                });
                buttonPanel.add((Component)this.m_okButton, gbCons);
            }
            ++gbCons.gridx;
            this.m_helpButton = new JButton(VWResource.s_help);
            this.m_helpButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    VWHelp.displayPage(VWHelp.Help_General + "bpfcg018.htm");
                }
            });
            buttonPanel.add((Component)this.m_helpButton, gbCons);
            return buttonPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private void buildTable() {
        Vector rowCache = new Vector();
        Vector<String> columnNames = new Vector<String>();
        columnNames.addElement(VWResource.s_workObject);
        columnNames.addElement(VWResource.s_subject);
        columnNames.addElement(VWResource.s_queue);
        for (int i = 0; i < this.m_vWobs.size(); ++i) {
            VWAdminWorkObjectTableData errData = (VWAdminWorkObjectTableData)this.m_vWobs.elementAt(i);
            this.insertElementToVector(rowCache, errData);
        }
        this.m_tableModel = new DefaultTableModel(rowCache, columnNames);
        this.m_table = new VWTable(this.m_tableModel);
        this.m_table.setEnabled(false);
        this.m_table.setShowGrid(false);
        VWAccessibilityHelper.setAccessibility(this.m_table, this, VWResource.s_detailsTable, VWResource.s_detailsTable);
        this.m_table.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (VWAdminManageTrackerErrorDialog.this.m_table == null || VWAdminManageTrackerErrorDialog.this.m_table.getModel() == null || VWAdminManageTrackerErrorDialog.this.m_table.getRowCount() == 0) {
                    FocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
                }
            }
        });
    }

    private void insertElementToVector(Vector vector, VWAdminWorkObjectTableData woData) {
        Vector<String> rowData = new Vector<String>();
        try {
            VWWorkObject wob = woData.getWob();
            rowData.addElement(wob.getWorkObjectNumber());
            rowData.addElement(wob.getSubject());
            rowData.addElement(wob.getCurrentQueueName());
            vector.addElement(rowData);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected boolean isYes() {
        return this.m_bYes;
    }
}

